/*
 * vim: set sw=8 ts=8 si :
 * Author: Guido Socher, Copyright: GPL 
 * 
 *
 * Chip type           : ATMEGA8
 * Clock frequency     : Internal clock 1 Mhz (factory default)
 */
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h> 
#include "i2c_avr.h"
#include "avr_compat.h"
#include "analog.h"
#include "ntc.h"
#include "lcd.h"

// send results to linux host in degree farenheit instead of celsius
//#define REPORT_FARENHE 1

void delay_ms(unsigned short ms)
/* delay for a minimum of <ms> */
/* with a 1Mhz clock, the resolution is 1 ms */
{
	uint8_t inner,inner1;

    	while (ms) {
		inner = 100;
		while (inner) {
			inner--;
			inner1 = 70;
			while (inner1) {
				inner1--;
			}
		}
		ms--;
	}
}

// convert a integer which is representing a float times 10 into a string
// e.g 674 becomes "67.4"
// the integer may not be larger that 10000
void int10_to_ascii(int inum,const char *prefixstr,char *outbuf){
	unsigned char i,l,j,minus;
	char chbuf[7];
	minus=0;
	j=0;
	if (inum<0){
		minus=1;
		inum=inum * -1;
	}
	while(inum>9 && j<7){
		// zero is ascii 48:
		chbuf[j]=(char)48+ inum-((inum/10)*10);
		inum=inum/10;
		j++;
	}
	chbuf[j]=(char)48+inum; // most significant digit
	// now reverse the order in outbuf and put a "." in there
	i=0;
	l=0;
	while(prefixstr[i]){
		outbuf[i]=prefixstr[i];
		i++;
	}
	if(minus){
		outbuf[i]='-';
		i++;
	}
	while(j>0){
		outbuf[i]=chbuf[j];
		j--;
		i++;
		l++;
	}
	// inum is less than 10, should be something like "0.inum"
	if (l==0){
		outbuf[i]='0';
		i++;
	}
	outbuf[i]='.';
	i++;
	outbuf[i]=chbuf[j];
	i++;
	outbuf[i]='\0';
}


void main(void)
{
	uint8_t rec_buf[MAX_BUF_LEN+1];
	char out_buf[MAX_BUF_LEN+1];
	// in house and outdoor sensor:
	int temp_sensor_in,temp_sensor_out;
	int i,led,lcdshow;
	double temp;
	unsigned char adc_ref_sel; // 0 -> avcc=ref
	temp_sensor_in=0;
	temp_sensor_out=0;
	// LED is output line:
	sbi(DDRD,PD5);
	// led off
	sbi(PORTD,PD5);
	// I2C also called TWI
	i2c_init(3,1,0);
	// initialize LCD display, cursor off
	lcd_init(LCD_DISP_ON);
	//
	sei();
	led=0;
	lcdshow=1;
	adc_ref_sel=0;
	while (1) {
		if (i2c_get_received_data(rec_buf)){
			if (rec_buf[0]=='i'){
				temp=r2temperature(adc_2_ohm_iref(temp_sensor_in),1);
#ifdef REPORT_FARENHE
				temp=c2f(temp);
#endif
				i=(int) (10.0 * temp);
				int10_to_ascii(i,"i=",out_buf);
				i2c_send_data(out_buf);
			}else if (rec_buf[0]=='o'){
				temp=r2temperature(adc_2_ohm_avcc(temp_sensor_out),0);
#ifdef REPORT_FARENHE
				temp=c2f(temp);
#endif
				i=(int) (10.0 * temp);
				int10_to_ascii(i,"o=",out_buf);
				i2c_send_data(out_buf);
			}else{
				i2c_send_data("err");
			}
		}
		// give the capacitor on the aref pin time to charge:
		if (led > 900){
			if (adc_ref_sel){
				// avoid adc noise by using averages (cheaper than hardware filters):
				temp_sensor_in=(temp_sensor_in+convertanalog(0,1))/2;
			}else{
				// avoid adc noise by using averages (cheaper than hardware filters):
				temp_sensor_out=(temp_sensor_out+convertanalog(1,0))/2;
			}
		}
		// let the led blink but only once in a while. It blinks when
		// we change measurement from inside to outside voltage
		led++;
		if (led == 3900){
			cbi(PORTD,PD5); // LED on
			adc_ref_sel++;
			// toggel between 0 and 1
			adc_ref_sel = adc_ref_sel % 2;
		}
		if (led > 4000){
			led=0;
			sbi(PORTD,PD5); // LED off
			lcdshow++;
		}
		if (lcdshow > 2){
			// update lcd display but not too ofter
			lcdshow=0;
			lcd_clrscr();
			temp=r2temperature(adc_2_ohm_iref(temp_sensor_in),1);
			// celsius
			i=(int) (10.0 * temp);
			int10_to_ascii(i,"In ",out_buf);
			lcd_puts(out_buf);
			lcd_puts("'C ");
			// farenheit
			i=(int) (c2f(temp) + 0.5);
			itoa(i,out_buf,10);
			lcd_puts(out_buf);
			lcd_puts("'F");
			// ----
			lcd_gotoxy(0,1); // second line
			temp=r2temperature(adc_2_ohm_avcc(temp_sensor_out),0);
			// celsius
			i=(int) (10.0 * temp);
			int10_to_ascii(i,"Ou ",out_buf);
			lcd_puts(out_buf);
			lcd_puts("'C ");
			// farenheit
			i=(int) (c2f(temp) + 0.5);
			itoa(i,out_buf,10);
			lcd_puts(out_buf);
			lcd_puts("'F");
		}
		
	}
}

